#include <stdio.h>
#include <string.h>

#define MAXN 200005

int N, Q;
int a[MAXN];

long long solve_small_k(int k) {
    int cnt[MAXN] = {0};
    int hand[105], hs = 0;

    for (int i = 1; i <= k; i++) {
        hand[hs++] = a[i];
        cnt[a[i]]++;
    }

    for (int i = k + 1; i <= N; i++) {
        // dodaj kartu
        cnt[a[i]]++;

        // izaberi x sa najvecim doprinosom
        int best = -1;
        long long bestv = 0;
        for (int j = 0; j < hs; j++) {
            int v = hand[j];
            if (cnt[v] * (long long)v > bestv) {
                bestv = cnt[v] * (long long)v;
                best = v;
            }
        }

        if (best != -1) {
            cnt[best] = 0;
            int nhs = 0;
            for (int j = 0; j < hs; j++)
                if (hand[j] != best)
                    hand[nhs++] = hand[j];
            hs = nhs;
        }

        hand[hs++] = a[i];
    }

    long long sum = 0;
    for (int i = 0; i < hs; i++) sum += hand[i];
    return sum;
}

long long solve_large_k(int k) {
    int cnt[MAXN] = {0};
    for (int i = 1; i <= k; i++) cnt[a[i]]++;

    int moves = N - k;
    while (moves--) {
        int best = -1;
        long long bestv = 0;
        for (int v = 1; v <= N; v++) {
            if (cnt[v] > 0 && (long long)cnt[v] * v > bestv) {
                bestv = (long long)cnt[v] * v;
                best = v;
            }
        }
        if (best == -1) break;
        cnt[best] = 0;
    }

    long long sum = 0;
    for (int v = 1; v <= N; v++)
        sum += (long long)v * cnt[v];
    return sum;
}

int main() {
    scanf("%d %d", &N, &Q);
    for (int i = 1; i <= N; i++) scanf("%d", &a[i]);

    while (Q--) {
        int t;
        scanf("%d", &t);
        if (t == 2) {
            int x, y;
            scanf("%d %d", &x, &y);
            a[x] = y;
        } else {
            int k;
            scanf("%d", &k);
            if (k <= 100)
                printf("%lld\n", solve_small_k(k));
            else if (k >= N - 100)
                printf("%lld\n", solve_large_k(k));
            else {
                long long s = 0;
                for (int i = 1; i <= k; i++) s += a[i];
                printf("%lld\n", s);
            }
        }
    }
    return 0;
}